//+------------------------------------------------------------------+
//|                                       Ma_Distance_From_Price.mq4 |
//|                              transport_david , David W Honeywell |
//|                                        transport.david@gmail.com |
//|                                            this version : mladen |
//+------------------------------------------------------------------+
#property strict
#property indicator_chart_window
#property indicator_buffers 5
#property indicator_color1 clrRed
#property indicator_color2 clrLime
#property indicator_color3 clrYellow
#property indicator_color4 clrYellow
#property indicator_color5 clrSkyBlue
#property indicator_width1 1
#property indicator_width2 1

//
//
//
//
//

extern int                MaPeriod           =   9;
extern int                MaShift            =   0;
extern ENUM_MA_METHOD     MaMethod           =   3;
extern ENUM_APPLIED_PRICE AppliedPrice       =   0;
extern int                HighPeriod           =   1;
extern int                HighShift            =   0;
extern ENUM_MA_METHOD     HighMethod           =   3;
extern ENUM_APPLIED_PRICE HighPrice       =   PRICE_HIGH;
extern int                LowPeriod           =   1;
extern int                LowShift            =   0;
extern ENUM_MA_METHOD     LowMethod           =   3;
extern ENUM_APPLIED_PRICE LowPrice       =   PRICE_LOW;
extern double             PipBuffer          = 1.5;
extern bool               alertsOn           = true;
extern bool               alertsOnCurrent    = true;
extern bool               alertsMessage      = true;
extern bool               alertsSound        = false;
extern bool               alertsEmail        = false;
extern bool               alertsNotification = false;

double ExtMapBuffer1[];
double ExtMapBuffer2[];
double Line1[],Line2[],ValMA[];
//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int init()
{
   SetIndexStyle(0,DRAW_ARROW,0,1); SetIndexArrow(0,226); SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexStyle(1,DRAW_ARROW,0,1); SetIndexArrow(1,225); SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexStyle(2,DRAW_LINE,0,1); SetIndexBuffer(2,Line1);
   SetIndexStyle(3,DRAW_LINE,0,1); SetIndexBuffer(3,Line2);
   SetIndexStyle(4,DRAW_LINE,0,1); SetIndexBuffer(4,ValMA);
   return(0);
}
int deinit()
{
   return(0);
}
//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int start()
{
   int counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
         double pipMul = MathPow(10,_Digits%2);
         int limit = MathMin(Bars-counted_bars,Bars-1);

   for (int i=limit; i>=0; i--) { ValMA[i] = iMA(NULL,0,MaPeriod,MaShift,MaMethod,AppliedPrice,i);
      ExtMapBuffer1[i] = EMPTY_VALUE;
      ExtMapBuffer2[i] = EMPTY_VALUE;
      Line1[i]=iMA(NULL,0,HighPeriod,HighShift,HighMethod,HighPrice,i)+PipBuffer*Point*pipMul/10;
      Line2[i]=iMA(NULL,0,LowPeriod,LowShift,LowMethod,LowPrice,i)-PipBuffer*Point*pipMul/10;
      if ( ValMA[i] > Line1[i]) ExtMapBuffer1[i] = High[i]+44*Point;
      if ( ValMA[i] < Line2[i]) ExtMapBuffer2[i] = Low[i] -44*Point;
   }
   manageAlerts();
   return(0);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

void manageAlerts()
{
   if (alertsOn)
   {
      int whichBar = 1; if (alertsOnCurrent) whichBar=0;
      if (ExtMapBuffer1[whichBar] != EMPTY_VALUE) doAlert(whichBar,"DOWN");
      if (ExtMapBuffer2[whichBar] != EMPTY_VALUE) doAlert(whichBar,"UP");
   }
}   

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  Symbol()+" M"+IntegerToString(Period())+"-"+TimeToStr(TimeLocal(),TIME_SECONDS)+ "->> SIGNAL "+doWhat;
          if (alertsMessage)      Alert(message);
          if (alertsEmail)        SendMail(Symbol()+"ma distance from price ",message);
          if (alertsNotification) SendNotification(message);
          if (alertsSound)        PlaySound("alert2.wav");
   }
}